/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.net;

import com.integpg.janoslib.logger.AppLog;
import com.integpg.janoslib.net.TcpServerEvent;
import com.integpg.janoslib.net.TcpServerListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class TcpServer
implements Runnable {
    private final String _name;
    private TcpServerListener _listener = null;
    private ServerSocket svrSocket;
    private Socket socket;
    private final int _port;
    private Thread _thread;
    private boolean bServerRun = true;

    public TcpServer(String name, int port) {
        this._name = name;
        this._port = port;
    }

    public void setTcpServerListener(TcpServerListener listener) {
        this._listener = listener;
    }

    public void start() {
        try {
            AppLog.info("Start server for " + this._name + " clients on port " + this._port + ".");
            this.svrSocket = new ServerSocket(this._port);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to start the server: " + ex.getMessage());
        }
        try {
            this._thread = new Thread(this);
            this._thread.setName(this.getClass().getName() + ":" + this._port);
            this._thread.setDaemon(true);
            this._thread.start();
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Unable to start the server: " + ex.getMessage());
        }
    }

    public void stop() throws IOException {
        this.bServerRun = false;
        this.svrSocket.close();
        try {
            this._thread.interrupt();
            this._thread.join();
        }
        catch (InterruptedException ex) {
            AppLog.error("Error stopping server socket: " + ex.getMessage());
        }
    }

    @Override
    public void run() {
        try {
            AppLog.info("Listening for " + this._name + " clients on port " + this._port);
            while (this.bServerRun) {
                try {
                    this.socket = this.svrSocket.accept();
                    if (this._listener == null) continue;
                    this._listener.clientConnected(new TcpServerEvent(this, this.socket));
                }
                catch (IOException ex) {
                    AppLog.error("Error accepting server socket connection", ex);
                    this.bServerRun = false;
                }
                catch (Exception ex) {
                    AppLog.error("Error accepting server socket connection", ex);
                }
            }
        }
        catch (Exception ex) {
            AppLog.error("Error accepting server socket connection: " + ex.getMessage());
            this.bServerRun = false;
        }
        try {
            this.svrSocket.close();
        }
        catch (IOException ex) {
            AppLog.error("Error closing server socket: " + ex.getMessage());
        }
        this.svrSocket = null;
    }
}

