/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.messaging.websocket;

import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.messaging.websocket.WebsocketClientInformation;
import com.integpg.janoslib.messaging.websocket.WebsocketMessageEventObject;
import com.integpg.janoslib.messaging.websocket.WebsocketMessageHandler;
import com.integpg.janoslib.messaging.websocket.WebsocketServer;
import java.util.Hashtable;
import java.util.Json;

public class PingHandler
extends WebsocketMessageHandler {
    public PingHandler() {
        super(null);
    }

    @Override
    public String getMessage() {
        return "ping";
    }

    @Override
    public void handleMessage(WebsocketMessageEventObject eventObject) throws Exception {
        WebsocketServer websocketServer = eventObject.getWebsocketServer();
        WebsocketClientInformation clientInformation = eventObject.getClientInformation();
        int msgId = eventObject.getMsgId();
        try {
            Hashtable loggedInClients = eventObject.getWebsocketServer().getLoggedInClients();
            if (loggedInClients.containsKey(clientInformation.getClientString())) {
                Json jsonResp = new Json("{\"Message\":\"ping-resp\"}");
                websocketServer.sendToWebsocket(clientInformation, jsonResp, msgId);
            } else {
                Json jsonResp = new Json("{\"Message\":\"Error\",\"Text\":\"401 Unauthorized\"}");
                websocketServer.sendToWebsocket(clientInformation, jsonResp, msgId);
            }
        }
        catch (Exception ex) {
            AppLog.error("Error replying to ping", ex);
            Json jsonResp = new Json("{\"Message\":\"Error\",\"Text\":\"" + ex.getMessage() + "\"}");
            websocketServer.sendToWebsocket(clientInformation, jsonResp, msgId);
        }
    }
}

