/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.messagepump;

import com.integ.janoslib.collections.BlockingQueue;
import com.integ.janoslib.messagepump.MessagePumpListener;
import com.integ.janoslib.messagepump.SystemMsgTypes;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.logger.SystemOutLog;
import com.integpg.system.MessagePump;
import com.integpg.system.SystemMsg;
import java.util.ArrayList;

public class MessagePumpEngine {
    private static final Logger LOG = null;
    private static final MessagePump MESSAGE_PUMP = new MessagePump();
    private static final BlockingQueue<SystemMsg> BLOCKING_QUEUE = new BlockingQueue();
    private static final ArrayList<MessagePumpListener> LISTENERS = new ArrayList();
    private static Thread _messagePumpThread;
    private static Thread _messageNotifierThread;

    private MessagePumpEngine() {
        BLOCKING_QUEUE.setName("MessagePumpEngineQueue");
    }

    public static Logger getLog() {
        if (null != LOG) {
            return LOG;
        }
        return SystemOutLog.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(MessagePumpListener listener) {
        ArrayList<MessagePumpListener> arrayList = LISTENERS;
        synchronized (arrayList) {
            LISTENERS.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        MessagePump messagePump = MESSAGE_PUMP;
        synchronized (messagePump) {
            if (null == _messagePumpThread) {
                _messagePumpThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("open the message pump and start monitoring.\r\n");
                        MESSAGE_PUMP.open();
                        while (true) {
                            SystemMsg systemMsg = MESSAGE_PUMP.getMessage();
                            MESSAGE_PUMP.postMessage(systemMsg);
                            try {
                                BLOCKING_QUEUE.put(systemMsg);
                                continue;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                continue;
                            }
                            break;
                        }
                    }
                });
                _messagePumpThread.setName(MessagePumpEngine.class.getName() + ":queue");
                _messagePumpThread.setDaemon(true);
                _messagePumpThread.start();
            }
            if (null == _messageNotifierThread) {
                _messageNotifierThread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            try {
                                while (true) {
                                    SystemMsg systemMsg = (SystemMsg)BLOCKING_QUEUE.get();
                                    try {
                                        String messageName = SystemMsgTypes.getMessageNameByType(systemMsg.type);
                                        String contents = "";
                                        if (1024 <= systemMsg.type) {
                                            contents = ": " + new String(systemMsg.msg).trim();
                                        }
                                        if (null != LOG) {
                                            String s = String.format("(%d) %s%s", systemMsg.type, messageName, contents);
                                            LOG.info(s);
                                        }
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                    ArrayList arrayList = LISTENERS;
                                    synchronized (arrayList) {
                                        for (MessagePumpListener listener : LISTENERS) {
                                            try {
                                                listener.messageReceived(systemMsg);
                                            }
                                            catch (Throwable ex) {
                                                ex.printStackTrace();
                                            }
                                        }
                                    }
                                    Thread.sleep(1L);
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                continue;
                            }
                            break;
                        }
                    }
                });
                _messageNotifierThread.setName(MessagePumpEngine.class.getName() + ":notifier");
                _messageNotifierThread.setDaemon(true);
                _messageNotifierThread.start();
            }
        }
    }

    public static void postMessage(SystemMsg msg) {
        MESSAGE_PUMP.postMessage(msg);
    }
}

