/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.analogpresets;

import com.integpg.analogpresets.ExternalModuleTransition;
import com.integpg.analogpresets.FourTwentyTransition;
import com.integpg.analogpresets.Jrmon;
import com.integpg.analogpresets.TenVoltTransition;
import com.integpg.analogpresets.ThreeChannelLedTransition;
import com.integpg.analogpresets.TriggerPointConfig;
import com.integpg.janoslib.io.AppLog;
import java.io.IOException;

public class Level {
    protected TriggerPointConfig _triggerPointConfig;
    protected ExternalModuleTransition _tenVoltModuleTransition;
    protected ExternalModuleTransition _fourTwentyModuleTransition;
    protected ExternalModuleTransition _threeChannelDimmerModuleTransition;

    public Level(TriggerPointConfig triggerPointConfig) {
        this._triggerPointConfig = triggerPointConfig;
    }

    public TriggerPointConfig getTriggerPointConfig() {
        return this._triggerPointConfig;
    }

    public void executeTransition(final String callerString) {
        Thread thd = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (null != Level.this._tenVoltModuleTransition) {
                        Level.this._tenVoltModuleTransition.executeTransition(callerString);
                    }
                    if (null != Level.this._fourTwentyModuleTransition) {
                        Level.this._fourTwentyModuleTransition.executeTransition(callerString);
                    }
                    if (null != Level.this._threeChannelDimmerModuleTransition) {
                        Level.this._threeChannelDimmerModuleTransition.executeTransition(callerString);
                    }
                    Thread.sleep(Level.this._triggerPointConfig.getTransitionTime());
                    Level.this.endTransition();
                }
                catch (Exception ex) {
                    AppLog.error("Error executing level: " + Level.this._triggerPointConfig.Name, ex);
                }
            }
        });
        thd.setDaemon(true);
        thd.start();
    }

    public void setThreeChannelLedTranstion(ThreeChannelLedTransition threeChannelLedTransition) {
        this._threeChannelDimmerModuleTransition = threeChannelLedTransition;
    }

    public void setFourTwentyTranstion(FourTwentyTransition fourTwentyTransition) {
        this._fourTwentyModuleTransition = fourTwentyTransition;
    }

    public void setTenVoltTranstion(TenVoltTransition tenVoltModuleTransition) {
        this._tenVoltModuleTransition = tenVoltModuleTransition;
    }

    protected void endTransition() {
        try {
            System.out.println("Level " + this._triggerPointConfig.Name + " Transition Complete");
            Jrmon.parseCommand(this._triggerPointConfig.EndRelayOutputAction);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String toString() {
        return this._triggerPointConfig.toString();
    }
}

