/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.analogpresets;

import com.integpg.analogpresets.AnalogPresetsMain;
import com.integpg.analogpresets.ExternalModuleTransition;
import com.integpg.analogpresets.TriggerPointConfig;
import com.integpg.janoslib.externalio.TypeFE;
import com.integpg.janoslib.logger.AppLog;
import java.io.IOException;

public class FourTwentyTransition
extends ExternalModuleTransition {
    private double[] _startValueOut;
    private double[] _deltaValueOut;

    public FourTwentyTransition(TriggerPointConfig triggerPointConfig) {
        super(triggerPointConfig);
    }

    @Override
    protected int getChannelsPerModule() {
        return 2;
    }

    public String toString() {
        return "FourTwentyLevel Channel " + this._triggerPointConfig.FourTwentyChannels[0] + ":   " + this._triggerPointConfig.toString();
    }

    @Override
    public void executeTransition(String callerString) {
        AppLog.info(callerString + " has triggered Four Twenty level: " + this._triggerPointConfig.Name);
        Thread thd = new Thread(this);
        thd.setName(this._triggerPointConfig.Name + ":TypeFE");
        thd.setDaemon(true);
        thd.start();
    }

    private void preTransition() throws IOException {
        this._startValueOut = new double[this._triggerPointConfig.FourTwentyChannels.length];
        this._deltaValueOut = new double[this._triggerPointConfig.FourTwentyChannels.length];
        TypeFE fe = null;
        int lastModuleIndex = -1;
        for (int i = 0; i < this._triggerPointConfig.FourTwentyChannels.length; ++i) {
            int channel = this._triggerPointConfig.FourTwentyChannels[i];
            int moduleIndex = this.getModuleIndex(channel);
            if (moduleIndex != lastModuleIndex) {
                fe = AnalogPresetsMain._feDevices[moduleIndex];
                System.out.println("Execute transition on " + fe.AddressString + ", channel: " + channel);
                fe.read();
            }
            this._startValueOut[i] = fe.scaleValue(fe.RawOut[this.getChannelIndexOnModule(channel)], 0.0, 100.0);
            this._deltaValueOut[i] = this._triggerPointConfig.Settings[this._triggerPointConfig.Settings.length != this._triggerPointConfig.FourTwentyChannels.length ? 0 : i] - this._startValueOut[i];
            System.out.println("Start vlaue: " + this._startValueOut[i] + " -> " + this._deltaValueOut[i]);
        }
    }

    @Override
    public void run() {
        try {
            this.preTransition();
            long start = System.currentTimeMillis();
            long transitionEnd = start + (long)this._triggerPointConfig.getTransitionTime();
            int writes = 0;
            int lastModuleIndex = -1;
            TypeFE fe = null;
            while (System.currentTimeMillis() <= transitionEnd) {
                for (int i = 0; i < this._triggerPointConfig.FourTwentyChannels.length; ++i) {
                    double percentThroughTransition = (double)(System.currentTimeMillis() - start) / (double)this._triggerPointConfig.getTransitionTime();
                    double newValueOut = this._deltaValueOut[i] * percentThroughTransition + this._startValueOut[i];
                    int channel = this._triggerPointConfig.FourTwentyChannels[i];
                    int moduleIndex = this.getModuleIndex(channel);
                    if (lastModuleIndex == -1) {
                        lastModuleIndex = moduleIndex;
                    }
                    if (moduleIndex != lastModuleIndex) {
                        try {
                            fe.commit();
                        }
                        catch (Exception ex) {
                            AppLog.error("Error setting Four Twenty module: " + fe.AddressString, ex);
                        }
                        lastModuleIndex = -1;
                    }
                    System.out.println("module index for channel " + channel + " is " + moduleIndex);
                    fe = AnalogPresetsMain._feDevices[moduleIndex];
                    System.out.println("Execute transition on " + fe.AddressString + ", channel: " + channel);
                    fe.setChannelPercentage(this.getChannelIndexOnModule(channel), newValueOut);
                }
                try {
                    fe.commit();
                }
                catch (Exception ex) {
                    AppLog.error("Error setting Four Twenty module: " + fe.AddressString, ex);
                }
                ++writes;
            }
            for (int i = 0; i < this._triggerPointConfig.FourTwentyChannels.length; ++i) {
                double newValueOut = this._deltaValueOut[i] + this._startValueOut[i];
                int channel = this._triggerPointConfig.FourTwentyChannels[i];
                int moduleIndex = this.getModuleIndex(channel);
                if (lastModuleIndex == -1) {
                    lastModuleIndex = moduleIndex;
                }
                if (moduleIndex != lastModuleIndex) {
                    try {
                        fe.commit();
                    }
                    catch (Exception ex) {
                        AppLog.error("Error setting Four Twenty module: " + fe.AddressString, ex);
                    }
                    lastModuleIndex = -1;
                }
                System.out.println("module index for channel " + channel + " is " + moduleIndex);
                fe = AnalogPresetsMain._feDevices[moduleIndex];
                System.out.println("Execute transition on " + fe.AddressString + ", channel: " + channel);
                fe.setChannelPercentage(this.getChannelIndexOnModule(channel), newValueOut);
            }
            try {
                fe.commit();
            }
            catch (Exception ex) {
                AppLog.error("Error setting Four Twenty module: " + fe.AddressString, ex);
            }
            System.out.println(writes + " writes in " + this._triggerPointConfig.getTransitionTime());
        }
        catch (Exception ex) {
            AppLog.error("Error executing Four Twenty Module", ex);
        }
    }
}

