var app = angular.module('AnalogPresetsApp', []);

app.controller('AnalogPresetsController', function($scope) {

    toastr.options.positionClass = 'toast-bottom-full-width';
    toastr.options.tapToDismiss = false;
    var $toastrArray = [];

    $scope.Version = "...";
    $scope.Config = {};
    $scope.SavedConfig = angular.copy($scope.Config);
    $scope.selectedLevel = "";
    $scope.Devices = {};

    var saveResponse = null;
    var loginDialog = null;

    $('#loading-info').html("Create websocket connection");

    $('#navbar a[href="#application-log-tab"]').click(function() {
        $scope.applicationLog = "Loading...";
        $scope.$apply();

        $.ajax({
            url: "/log.php?filename=analogpresets.log",
            context: document.body
        }).done(function(data) {
            $scope.applicationLog = data;
            $scope.$apply();

            setTimeout(function() {
                var docHeight = $(document).height();
                $("html, body").animate({scrollTop: docHeight}, 500);
            }, 1);
        });
    });


    // create our websocket connection
    var webSocket = new JnrWebSocket({
        defaultIpAddress: "10.0.0.43",
        appId: 5004,
        onopen: function(evt) {
            webSocket.messageHandlers['Error'] = error;
            webSocket.messageHandlers['config-resp'] = configResp;
            $scope.getConfig();
            getCredentials(evt, null);
        },
        getAuthentication: function(evt, jobj) {
            getCredentials(evt, jobj);
        },
        authenticated: function(evt, jobj) {
            loginDialog.modal('hide');

            if ($toastrArray['login'] != null) {
                $toastrArray['login'].attr('class', 'toast toast-success');
                $toastrArray['login'].html('User logged in');
                setTimeout(function() {
                    toastr.clear($toastrArray['login']);
                    $toastrArray['login'] = null;
                }, 100);
            }
        }

    });
    webSocket.connect();



    function getCredentials(evt, jobj) {
        var modalAlreadyOpen = $('#login-dialog').hasClass('in');
        if (!modalAlreadyOpen) {
            loginDialog = bootbox.dialog({
                closeButton: false,
                title: "Please enter your user credentials",
                message: '<form role="form">' +
                        '    <div class="modal-body">' +
                        '        <div class="form-group">' +
                        '            <label for="login-username">Username</label>' +
                        '            <input type="text" class="form-control" id="login-username" placeholder="Enter username" >' +
                        '        </div>' +
                        '        <div class="form-group">' +
                        '            <label for="login-password">Password</label>' +
                        '            <input type="password" class="form-control" id="login-password" placeholder="Enter password" >' +
                        '        </div>' +
                        '    </div>' +
                        '</form>',
                buttons: {
                    main: {
                        label: "Login",
                        className: "btn-primary",
                        callback: function() {
                            var username = $('#login-username').val();
                            var password = $('#login-password').val();
                            $scope.login(username, password);
                            return false;
                        }
                    }
                }
            });
            loginDialog.attr('id', 'login-dialog');

            loginDialog.on("shown.bs.modal", function() {
                _loginSent = true;
                $('#login-username').focus();
            });

            loginDialog.keypress(function(e) {
                if (e.which === 13) {
                    var username = $('#login-username').val();
                    var password = $('#login-password').val();
                    $scope.login(username, password);
                }
            });
        }
    }



    $scope.login = function(username, password) {
        // $("#login-status").css({color:'#5cb85c'}).html("Logging in").show();
        // $('#loading-info').html("Logging in...");

        if ($toastrArray['login'] != null) {
            $toastrArray['login'].attr('class', 'toast toast-info');
            $toastrArray['login'].html("Logging in as '" + username + "'...");
        } else
            $toastrArray['login'] = toastr.info("Logging in as '" + username + "'...", "", {timeOut: 0});

        setTimeout(function() {
            var response = {};
            response.Message = 'login';
            response.Username = username;
            response.Password = password;
            webSocket.sendJson(response);

            _loginSent = true;
        }, 100);
    }



    var error = function(evt, jobj) {
        if (jobj.Text == 'Login Failed') {
            if (_loginSent) {
                // if ($toastrArray['login'] != null) {
                //     toastr.clear($toastrArray['login']);
                //     $toastrArray['login'] = null;
                // }
                // $toastrArray['login'] = toastr.error("Either the Username or Password was incorrect", { timeOut: 0 });
                if ($toastrArray['login'] != null) {
                    $toastrArray['login'].attr('class', 'toast toast-error');
                    $toastrArray['login'].html('Either the Username or Password was incorrect');
                }
            }
        }
    };



    $scope.getHelpText = function() {
        if ($scope.Config.LevelSettings == undefined || $scope.Config.LevelSettings.length == 0)
            return "Please click 'Add Level' to add your first level";
        else if ($scope.selectedLevel === "")
            return "Please select a level";
        else
            return "";
    };



    $scope.setSelectedLevel = function(level) {
        $scope.selectedLevel = level;
    };



    $scope.isLevelSelected = function() {
        return $scope.selectedLevel != "";
    };



    $scope.areDevicesPresent = function(deviceType) {
        return $scope.Devices[deviceType] == true;
    };



    $scope.setDeviceTooltip = function(deviceType, deviceName) {
        var $element = $('#' + deviceType + '-tooltip');
        $element.tooltip('hide');
        $element.attr('data-original-title', $scope.areDevicesPresent(deviceType)
                ? "Enter channel numbers to be controlled by this Level.  Multiple channel numbers are separated by commas."
                : deviceName + " device not present.  If device expected check connections"
                );
        $element.tooltip('fixTitle');
    };



    $scope.getConfig = function() {
        $('#loading-info').html("Getting Configuration");

        if ($toastrArray['getConfig'] != null) {
            $toastrArray['getConfig'].attr('class', 'toast toast-info');
            $toastrArray['getConfig'].html("Getting configuration...");
        } else
            $toastrArray['getConfig'] = toastr.info("Getting configuration...", "", {timeOut: 0});

        setTimeout(function() {
            var json = new Object();
            json['Message'] = "get-config";
            webSocket.sendJson(json);
        }, 100);
    };



    $scope.saveConfig = function() {
        bootbox.confirm({
            title: "Are you sure you want to save your changes?",
            message: "Saving your configuration will take effect right away",
            callback: function(result) {
                if (result) {
                    if ($toastrArray['save-config'] != null) {
                        $toastrArray['save-config'].attr('class', 'toast toast-info');
                        $toastrArray['save-config'].html("Saving configuration...");
                    } else
                        $toastrArray['save-config'] = toastr.info("Saving configuration...", "", {timeOut: 0});

                    setTimeout(function() {
                        var msg = {};
                        msg.Message = 'save-config';
                        msg.Config = $scope.Config;
                        webSocket.sendJson(msg);
                    }, 100);
                }
            }
        });
    };



    $scope.cancelConfig = function() {
        bootbox.confirm({
            title: "Are you sure you want to cancel your changes?",
            message: "Cancelling your changes will reload the last saved settings",
            callback: function(result) {
                if (result)
                    $scope.getConfig();
            }
        });
    };



    function sortLevels() {
        $scope.Config.LevelSettings.sort(function(a, b) {
            if (!a || !b) return 1;
            console.log(a.Name + " " + b.Name);
            if (a.Name > b.Name)
                return 1;
            else if (a.Name < b.Name)
                return -1;
            else
                return 0;
        });
    }



    var configResp = function(evt, jobj) {
        $scope.Version = jobj.Version;

        $scope.Config = jobj.Config;
        if ($scope.Config.GlobalTransitionTime == undefined)
            $scope.Config.GlobalTransitionTime = 5000;
        if ($scope.Config.LevelSettings == undefined)
            $scope.Config.LevelSettings = [];
        if ($scope.Config.Client == undefined)
            $scope.Config.Client = {TcpServerPort: 9700, TerminationString: "\\r\\n"};
        if ($scope.Config.Client.TcpServerPort == '')
            $scope.Config.Client.TcpServerPort = 9700;
        if ($scope.Config.Client.TerminationString == '')
            $scope.Config.Client.TerminationString = "\\r\\n";

        sortLevels();
//        $scope.Config.LevelSettings.sort(function(a, b) {
////            console.log(a.Name + " " + b.Name);
//            if (a.Name > b.Name)
//                return 1;
//            else if (a.Name < b.Name)
//                return -1;
//            else
//                return 0;
//        });
        for (index = 0; index < $scope.Config.LevelSettings.length; index++) {
            if ($scope.Config.LevelSettings[index]) {
                console.log("   " + $scope.Config.LevelSettings[index].Name);
                if ($scope.Config.LevelSettings[index].Name == $scope.selectedLevel.Name)
                    $scope.setSelectedLevel($scope.Config.LevelSettings[index]);
            } else {
                $scope.Config.LevelSettings.splice(index, 1);
            }
        }

        $scope.SavedConfig = angular.copy($scope.Config);

        $scope.Devices = jobj.Devices;
        $scope.setDeviceTooltip('FourTwentyPresent', '4-20ma');
        $scope.setDeviceTooltip('TenVoltPresent', '10v');
        $scope.setDeviceTooltip('ThreeChannelLEDPresent', '3 Channel LED');
//        $('[data-toggle="tooltip"]').tooltip({container: 'body', html: true, template: '<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner" style="text-align:left; max-width:400px;"></div></div>'});

        $scope.$apply();

        if ($toastrArray['getConfig'] != null) {
            $toastrArray['getConfig'].attr('class', 'toast toast-success');
            $toastrArray['getConfig'].html('Configuration Received');
            setTimeout(function() {
                toastr.clear($toastrArray['getConfig']);
                $toastrArray['getConfig'] = null;
            }, 1000);
        }

        if ($toastrArray['save-config'] != null) {
            $toastrArray['save-config'].attr('class', 'toast toast-success');
            $toastrArray['save-config'].html('Configuration saved Successfully');
            setTimeout(function() {
                toastr.clear($toastrArray['save-config']);
                $toastrArray['save-config'] = null;
            }, 1000);
        }
    };



    $scope.addLevel = function() {
        addNewDialog = bootbox.dialog({
            closeButton: false,
            title: "Add Level",
            message: '<form role="form">' +
                    '    <div class="modal-body">' +
                    '        <p>What is the name of the new Level?</p>' +
                    '        <div class="form-group">' +
                    '            <input type="text" class="form-control" id="new-level-name" placeholder="Enter New Level Name" >' +
                    '        </div>' +
                    '    </div>' +
                    '</form>',
            buttons: {
                success: {
                    label: "Add",
                    className: "btn-primary",
                    callback: function() {
                        var newLevelName = $('#new-level-name').val();
                        if (addNewLevelByName(newLevelName)) {
                            addNewDialog.modal('hide');
                        }
                        return false;
                    }
                },
                main: {
                    label: "Cancel",
                    className: "btn-default",
                    callback: function() {
                        addNewDialog.modal('hide');
                    }
                }

            }
        });
        addNewDialog.attr('id', 'add-new-dialog');

        addNewDialog.on("shown.bs.modal", function() {
            $('#new-level-name').focus();
        });

        addNewDialog.keypress(function(e) {
            if (e.which === 13) {
                var newLevelName = $('#new-level-name').val();
                if (addNewLevelByName(newLevelName)) {
                    addNewDialog.modal('hide');
                }
                return false;
            }
        });
    };



    function addNewLevelByName(newLevelName) {
        // check to see if this level already exists
        var found = false;
        $.each($scope.Config.LevelSettings, function(index) {
            if ($scope.Config.LevelSettings[index] &&
                    $scope.Config.LevelSettings[index].Name === newLevelName)
                found = true;
        });

        if (found) {
            alert("'" + newLevelName + "' already exists!");
            return false;
        }

        if (newLevelName.indexOf(' ') >= 0) {
            alert("The entered level name of '" + newLevelName + "' cannot contain spaces!");
            return false;
        }

        var newLevel = {Name: newLevelName};
        $scope.Config.LevelSettings.push(newLevel);
        sortLevels();
//                    $scope.Config.LevelSettings.sort(function(a, b) {
////                    console.log(a.Name + " " + b.Name);
//                        if (a.Name > b.Name)
//                            return 1;
//                        else if (a.Name < b.Name)
//                            return -1;
//                        else
//                            return 0;
//                    });
        for (i = 0; i < $scope.Config.LevelSettings.length; i++) {
            console.log("   " + $scope.Config.LevelSettings[i].Name);
        }

        $scope.setSelectedLevel(newLevel);
        $scope.$apply();

        $('html, body').animate({
            scrollTop: ($('#' + newLevelName).offset().top)
        }, 500);

        return true;
    }



    $scope.removeLevel = function() {
        bootbox.confirm({
            title: "Remove Level",
            message: "Are you sure you want to remove the " + $scope.selectedLevel.Name + " level?",
            callback: function(result) {
                if (result) {
                    // delete $scope.Config.LevelSettings[$scope.selectedLevel];
                    findAndRemove($scope.Config.LevelSettings, $scope.selectedLevel);
                    $scope.setSelectedLevel("");
                    $scope.$apply();
                }
            }
        });
    };



    $scope.executeLevel = function() {
        bootbox.confirm({
            title: "Execute Level",
            message: "Are you sure you want to execute the " + $scope.selectedLevel.Name + " level?",
            callback: function(result) {
                if (result) {
                    var msg = {};
                    msg.Message = 'execute-level';
                    msg.LevelName = $scope.selectedLevel.Name;
                    webSocket.sendJson(msg);
                }
            }
        });
    };



    $scope.hasConfigChanged = function() {
        return !angular.equals($scope.Config, $scope.SavedConfig);
    };



    function isEmpty(obj) {
        for (var prop in obj) {
            if (obj.hasOwnProperty(prop))
                return false;
        }

        return true;
    }
    ;



    // $scope.getLevels = function() {
    //     var levels = [];
    //     for (var key in $scope.Config.LevelSettings) {
    //         if ($scope.Config.LevelSettings.hasOwnProperty(key)) {
    //             levels.push(key);
    //             levels[key] = $scope.Config.LevelSettings[key];
    //         }
    //     }
    //     return levels;
    // };



    function findAndRemove(array, value) {
        $.each(array, function(index, result) {
            if (result == value) {
                array.splice(index, 1);
                return;
            }
        });
    }

});