/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.externalio.RegistryEnumerateModules;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.janoslib.utils.RegistryUtils;
import com.integpg.sensor.SensorPort;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.util.Date;

public class TypeFE
extends ExternalModule {
    public int[] RawIn = new int[4];
    public int[] RawOut = new int[2];
    private final byte[] _writeBytes = new byte[4];
    private boolean _initialized = false;

    public static TypeFE getByIndex(int index) {
        String typeIndexRegistryKey = String.format("externals/deviceorder/%s_%d", "TypeFE", index + 1);
        String addressString = JANOS.getRegistryString((String)typeIndexRegistryKey, null);
        if (null != addressString) {
            if (!ModulesByAddress.containsKey(addressString)) {
                long address = HexUtils.parseHexAsLong(addressString);
                TypeFE typeFe = new TypeFE(address, index + 1);
                ModulesByAddress.put(addressString, typeFe);
            }
            return (TypeFE)ModulesByAddress.get(addressString);
        }
        return null;
    }

    public TypeFE(long address, int index) {
        super(address, index, "TypeFE");
    }

    private void initialize() {
        try {
            this.read();
            ArrayUtils.setShort((byte[])this._writeBytes, (int)0, (short)((short)this.RawOut[0]));
            ArrayUtils.setShort((byte[])this._writeBytes, (int)1, (short)((short)this.RawOut[1]));
            this._initialized = true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static TypeFE[] getDeviceArray() {
        RegistryEnumerateModules registryEnumerateModules = new RegistryEnumerateModules("FE");
        String[] externalDeviceAddressStrings = registryEnumerateModules.getExternalDeviceAddressStrings();
        TypeFE[] deviceArray = new TypeFE[externalDeviceAddressStrings.length];
        for (int i = 0; i < externalDeviceAddressStrings.length; ++i) {
            String deviceString = externalDeviceAddressStrings[i];
            System.out.println("found: " + deviceString);
            long deviceAddress = TypeFE.getDeviceAddressForDeviceString(deviceString);
            deviceArray[i] = new TypeFE(deviceAddress, i + 1);
        }
        return deviceArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() throws IOException {
        long timeSinceLastRead = System.currentTimeMillis() - this.LastReadTime;
        if (100L < timeSinceLastRead) {
            SensorPort sensorPort = SENSOR_PORT;
            synchronized (sensorPort) {
                this._dataBlock = JANOS.readDeviceBlock((long)this.Address);
                if (this._dataBlock.length != 12) {
                    throw new IOException("Unable to read " + this.AddressString);
                }
            }
            this.LastReadTime = System.currentTimeMillis();
            if (null != this._dataBlock) {
                int channel;
                for (channel = 0; channel < 4; ++channel) {
                    this.RawIn[channel] = ArrayUtils.getShort((byte[])this._dataBlock, (int)(channel * 2)) & 0xFFFF;
                }
                for (channel = 0; channel < 2; ++channel) {
                    this.RawOut[channel] = ArrayUtils.getShort((byte[])this._dataBlock, (int)(channel * 2 + 8)) & 0xFFFF;
                }
            }
            if (null != this.TypeString && RegistryUtils.getRegistryKey("Externals/" + this.TypeString + "/UpdateRegistryWithValues", false)) {
                JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$In1"), (String)String.valueOf(this.getScaledInput(1)));
                JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$In2"), (String)String.valueOf(this.getScaledInput(2)));
                JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$In3"), (String)String.valueOf(this.getScaledInput(3)));
                JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$In4"), (String)String.valueOf(this.getScaledInput(4)));
                JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$Out1"), (String)String.valueOf(this.getScaledOutput(1)));
                JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$Out2"), (String)String.valueOf(this.getScaledOutput(2)));
                JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$LastReadTime"), (String)QUICK_DATE_FORMAT.format(System.currentTimeMillis()));
            }
        }
    }

    public void setChannelPercentage(int channel, double percent) {
        if (!this._initialized) {
            this.initialize();
        }
        int raw = (int)(percent / 100.0 * 65520.0);
        ArrayUtils.setShort((byte[])this._writeBytes, (int)(channel * 2), (short)((short)raw));
    }

    public void setChannelAmps(int channel, double amps) {
        double min = 4.0;
        double max = 20.0;
        double targetDelta = amps - min;
        double totalDelta = max - min;
        double percentage = targetDelta / totalDelta;
        this.setChannelPercentage(channel, percentage * 100.0);
    }

    public void setChannel(int channel, int value) {
        if (!this._initialized) {
            this.initialize();
        }
        ArrayUtils.setShort((byte[])this._writeBytes, (int)((channel - 1) * 2), (short)((short)value));
    }

    public double getScaledInput(int channel) {
        String channelBaseString = "Externals/" + this.AddressString + "/Ain" + channel;
        double min = JANOS.getRegistryDouble((String)(channelBaseString + "/Min"), (double)4.0);
        double max = JANOS.getRegistryDouble((String)(channelBaseString + "/Max"), (double)20.0);
        double value = this.scaleValue(this.RawIn[channel - 1], min, max);
        return value;
    }

    public double getScaledOutput(int channel) {
        String channelBaseString = "Externals/" + this.AddressString + "/Aout" + channel;
        double min = JANOS.getRegistryDouble((String)(channelBaseString + "/Min"), (double)0.0);
        double max = JANOS.getRegistryDouble((String)(channelBaseString + "/Max"), (double)100.0);
        double value = this.scaleValue(this.RawOut[channel - 1], min, max);
        return value;
    }

    public String getInputUnits(int channel) {
        String channelBaseString = "Externals/" + this.AddressString + "/Ain" + channel;
        return JANOS.getRegistryString((String)(channelBaseString + "/Units"), (String)"ma");
    }

    public String getOutputUnits(int channel) {
        String channelBaseString = "Externals/" + this.AddressString + "/Aout" + channel;
        return JANOS.getRegistryString((String)(channelBaseString + "/Units"), (String)"ma");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws IOException {
        SensorPort sensorPort = SENSOR_PORT;
        synchronized (sensorPort) {
            JANOS.writeDeviceBlock((long)this.Address, (byte[])this._writeBytes);
            this.LastWriteTime = System.currentTimeMillis();
        }
    }

    @Override
    public void printValues() {
        int channel;
        System.out.println("Read " + this.AddressString + " @ " + new Date(this.LastReadTime));
        for (channel = 0; channel < 4; ++channel) {
            System.out.println("In " + (channel + 1) + ": " + this.RawIn[channel] + "   " + this.getScaledInput(channel + 1));
        }
        for (channel = 0; channel < 2; ++channel) {
            System.out.println("Out " + (channel + 1) + ": " + this.RawIn[channel] + "   " + this.getScaledOutput(channel + 1));
        }
    }

    @Override
    public Object get(String fieldName) {
        int channel = 1;
        int underscorePos = fieldName.indexOf("_");
        if (-1 != underscorePos) {
            channel = Integer.parseInt(fieldName.substring(underscorePos + 1));
            fieldName = fieldName.substring(0, underscorePos);
        }
        if ("rawin".equalsIgnoreCase(fieldName)) {
            return this.RawIn[channel - 1];
        }
        if ("scaledin".equalsIgnoreCase(fieldName)) {
            return this.getScaledInput(channel);
        }
        if ("descin".equalsIgnoreCase(fieldName)) {
            String registryKeyString = String.format("externals/%s/ain%d/desc", this.AddressString, channel);
            return JANOS.getRegistryString((String)registryKeyString, (String)("Channel " + channel));
        }
        if ("unitsin".equalsIgnoreCase(fieldName)) {
            String registryKeyString = String.format("externals/%s/ain%d/units", this.AddressString, channel);
            return JANOS.getRegistryString((String)registryKeyString, (String)"ma");
        }
        if ("rawout".equalsIgnoreCase(fieldName)) {
            return this.RawOut[channel - 1];
        }
        if ("scaledout".equalsIgnoreCase(fieldName)) {
            return this.getScaledOutput(channel);
        }
        if ("descout".equalsIgnoreCase(fieldName)) {
            String registryKeyString = String.format("externals/%s/aout%d/desc", this.AddressString, channel);
            return JANOS.getRegistryString((String)registryKeyString, (String)("Channel " + channel));
        }
        if ("unitsout".equalsIgnoreCase(fieldName)) {
            String registryKeyString = String.format("externals/%s/aout%d/units", this.AddressString, channel);
            return JANOS.getRegistryString((String)registryKeyString, (String)"%");
        }
        throw new RuntimeException("Invalid Field Name: " + fieldName);
    }
}

