/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.analogpresets.client;

import com.integpg.analogpresets.IClient;
import com.integpg.analogpresets.client.ClientConnectionListener;
import com.integpg.analogpresets.client.ClientHandler;
import com.integpg.analogpresets.configuration.Config;
import com.integpg.janoslib.logger.AppLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class ClientConnection
implements Runnable,
IClient {
    private Socket _socket;
    private InputStream _inStream;
    private OutputStream _outStream;
    private ClientConnectionListener _listener;
    public String _socketInfo;

    public ClientConnection(Socket socket) {
        try {
            this._socket = socket;
            this._socketInfo = String.format("%s:%d (tcp port %d)", this._socket.getInetAddress().getHostAddress(), this._socket.getPort(), this._socket.getLocalPort());
            this._inStream = socket.getInputStream();
            this._outStream = socket.getOutputStream();
            AppLog.info(this._socketInfo + " is connected");
            Thread thd = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                        ClientConnection.this.send("Client Connected");
                    }
                    catch (InterruptedException ex) {
                        AppLog.error(ex);
                    }
                }
            });
            thd.start();
        }
        catch (IOException ex) {
            AppLog.error(ex);
        }
    }

    @Override
    public String getSocketInfo() {
        return this._socketInfo;
    }

    private void closeSocket() {
        try {
            if (null != this._inStream) {
                this._inStream.close();
                this._inStream = null;
            }
            if (null != this._outStream) {
                this._outStream.close();
                this._outStream = null;
            }
            if (null != this._socket) {
                this._socket.close();
                this._socket = null;
            }
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
        }
    }

    public void setListener(ClientConnectionListener listener) {
        this._listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Thread.currentThread().setName(this._socketInfo);
            ClientHandler ch = new ClientHandler(this._inStream, this._socket != null);
            byte[] terminationBytes = Config.getTerminationBytes();
            ch.setTerminationBytes(terminationBytes);
            while (this._socket != null) {
                String message = ch.getMessage();
                if (this._listener != null) {
                    if (!message.equals("")) {
                        this._listener.processMessage(this, message);
                        continue;
                    }
                    break;
                }
                AppLog.error("Client listener not defined");
            }
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            if (message != null && message.equalsIgnoreCase("socket closed")) {
                AppLog.info(this._socketInfo + " has disconnected");
            } else {
                AppLog.error(ex);
            }
        }
        finally {
            this.closeSocket();
        }
    }

    @Override
    public synchronized void send(String s) {
        try {
            if (null != this._outStream) {
                this._outStream.write(s.getBytes());
                this._outStream.write(Config.getTerminationBytes());
                this._outStream.flush();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

