/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.messaging.websocket;

import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.messaging.CustomMessageListener;
import com.integpg.janoslib.messaging.MessageLoop;
import com.integpg.janoslib.messaging.websocket.LoginHandler;
import com.integpg.janoslib.messaging.websocket.PingHandler;
import com.integpg.janoslib.messaging.websocket.RegistryReadHandler;
import com.integpg.janoslib.messaging.websocket.RegistryWriteHandler;
import com.integpg.janoslib.messaging.websocket.WebSocketPipeListener;
import com.integpg.janoslib.messaging.websocket.WebsocketClientInformation;
import com.integpg.janoslib.messaging.websocket.WebsocketConnectionEventObject;
import com.integpg.janoslib.messaging.websocket.WebsocketMessageEventObject;
import com.integpg.janoslib.messaging.websocket.WebsocketMessageHandler;
import com.integpg.janoslib.messaging.websocket.WebsocketServerListener;
import com.integpg.system.ArrayUtils;
import com.integpg.system.SystemMsg;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Json;
import java.util.Vector;

public class WebsocketServer
implements WebSocketPipeListener,
CustomMessageListener {
    private final Vector _websocketMessageListeners = new Vector();
    private final Hashtable _clientConnections = new Hashtable();
    private final Hashtable _loggedInClients = new Hashtable();
    private final Hashtable _websocketMessageHandlers = new Hashtable();
    private boolean _debug = false;

    public WebsocketServer() {
        this.addMessageHandler(new PingHandler());
        this.addMessageHandler(new LoginHandler());
        this.addMessageHandler(new RegistryReadHandler());
        this.addMessageHandler(new RegistryWriteHandler());
        this.listenForConnections();
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    private void listenForConnections() {
        MessageLoop.addWebsocketPipeListeners(this);
    }

    public void addMessageListener(int id, WebsocketServerListener listener) {
        MessageLoop.addCustomMessageListeners(id, this);
        this._websocketMessageListeners.addElement(listener);
    }

    public void addMessageHandler(WebsocketMessageHandler handler) {
        this._websocketMessageHandlers.put(handler.getMessage(), handler);
    }

    public boolean containsMessageHandler(String handlerName) throws Exception {
        return this._websocketMessageHandlers.containsKey(handlerName);
    }

    public WebsocketMessageHandler getWebsocketMessageHandler(String handlerName) throws Exception {
        if (this._websocketMessageHandlers.containsKey(handlerName)) {
            return (WebsocketMessageHandler)this._websocketMessageHandlers.get(handlerName);
        }
        throw new Exception("A handler for " + handlerName + " does not exist");
    }

    public Hashtable getLoggedInClients() {
        return this._loggedInClients;
    }

    @Override
    public void webSocketPipeOpened(WebsocketClientInformation clientInformation) {
        System.out.println("Pipe Opened: " + clientInformation.getClientString());
        if (!this._clientConnections.containsKey(clientInformation.getClientString())) {
            this._clientConnections.put(clientInformation.getClientString(), clientInformation);
        }
        for (int i = 0; i < this._websocketMessageListeners.size(); ++i) {
            WebsocketServerListener listener = (WebsocketServerListener)this._websocketMessageListeners.elementAt(i);
            listener.websocketClientConnected(new WebsocketConnectionEventObject(this, clientInformation));
        }
    }

    @Override
    public void webSocketPipeClosed(WebsocketClientInformation clientInformation) {
        System.out.println("Pipe Closed: " + clientInformation.getClientString());
        if (this._clientConnections.containsKey(clientInformation.getClientString())) {
            this._clientConnections.remove(clientInformation.getClientString());
            for (int i = 0; i < this._websocketMessageListeners.size(); ++i) {
                WebsocketServerListener listener = (WebsocketServerListener)this._websocketMessageListeners.elementAt(i);
                listener.websocketClientDisconnected(new WebsocketConnectionEventObject(this, clientInformation));
            }
        }
    }

    @Override
    public void messageReceived(SystemMsg msg) {
        WebsocketClientInformation clientInformation;
        String clientString;
        byte[] sender = this.getSenderInformation(msg);
        byte[] data = this.getData(msg);
        if (this._debug) {
            System.out.println("Custom Message Received: " + msg.type);
        }
        if (!this._clientConnections.containsKey(clientString = WebsocketClientInformation.getClientString(sender))) {
            clientInformation = new WebsocketClientInformation(sender);
            this.webSocketPipeOpened(clientInformation);
        }
        if (this._clientConnections.containsKey(clientString)) {
            clientInformation = (WebsocketClientInformation)this._clientConnections.get(clientString);
            String jsonString = new String(data);
            Json json = new Json(jsonString);
            if (json.get("Message") == null || !this.tryUseMessageHandler(new WebsocketMessageEventObject(this, clientInformation, json, msg.type))) {
                System.out.println("Custom Message Received: " + new String(data));
                for (int i = 0; i < this._websocketMessageListeners.size(); ++i) {
                    WebsocketServerListener listener = (WebsocketServerListener)this._websocketMessageListeners.elementAt(i);
                    listener.websocketMessageReceived(new WebsocketMessageEventObject(this, clientInformation, json, msg.type));
                }
            }
        }
    }

    private boolean tryUseMessageHandler(WebsocketMessageEventObject eventObject) {
        try {
            if (this._debug) {
                System.out.println("Websocket message received from " + eventObject.getClientInformation().getClientString());
            }
            String messageType = (String)eventObject.getJson().get("Message");
            if (this._debug) {
                System.out.println("Message: " + messageType);
            }
            if (messageType == null) {
                throw new Exception("Message is null");
            }
            if (this._debug) {
                System.out.println("message handler for " + messageType + "? " + this.containsMessageHandler(messageType));
            }
            if (this.containsMessageHandler(messageType)) {
                WebsocketMessageHandler handler = this.getWebsocketMessageHandler(messageType);
                handler.handleMessage(eventObject);
                return true;
            }
        }
        catch (Exception ex) {
            AppLog.error("Error processing web socket message: " + ex.getMessage());
            ex.printStackTrace();
        }
        return false;
    }

    private byte[] getSenderInformation(SystemMsg msg) {
        byte[] sender = new byte[6];
        ArrayUtils.arraycopy((Object)msg.msg, (int)0, (Object)sender, (int)0, (int)6);
        return sender;
    }

    private byte[] getData(SystemMsg msg) {
        byte[] data = new byte[msg.msg.length - 6];
        ArrayUtils.arraycopy((Object)msg.msg, (int)6, (Object)data, (int)0, (int)data.length);
        return data;
    }

    public void sendToWebsocket(WebsocketClientInformation client, Json json, int appId) throws Exception {
        if (json == null) {
            throw new Exception("Json message is null");
        }
        if (client == null) {
            try {
                Enumeration e = this._clientConnections.elements();
                while (e.hasMoreElements()) {
                    WebsocketClientInformation clientInformation = (WebsocketClientInformation)e.nextElement();
                    if (clientInformation == null) continue;
                    this.sendToWebsocket(clientInformation, json, appId);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Exception("Error broadcasting websocket message: " + ex.toString());
            }
        }
        try {
            if (this._debug) {
                System.out.println("Send to " + client.getClientString());
            }
            byte[] payload = json.toString().getBytes();
            SystemMsg msg = new SystemMsg();
            msg.type = appId + 1;
            msg.msg = new byte[6 + payload.length];
            ArrayUtils.arraycopy((Object)client.getSender(), (int)0, (Object)msg.msg, (int)0, (int)6);
            ArrayUtils.arraycopy((Object)payload, (int)0, (Object)msg.msg, (int)6, (int)payload.length);
            MessageLoop.postMessage(msg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("Error sending websocket message: " + ex.toString());
        }
    }
}

