/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.analogpresets;

import com.integpg.analogpresets.AnalogPresetsMain;
import com.integpg.analogpresets.ExternalModuleTransition;
import com.integpg.analogpresets.TriggerPointConfig;
import com.integpg.janoslib.io.AppLog;
import com.integpg.sensor.SensorPort;
import com.integpg.system.ArrayUtils;

public class ThreeChannelLedTransition
extends ExternalModuleTransition {
    private static final SensorPort port = new SensorPort();

    public ThreeChannelLedTransition(TriggerPointConfig triggerPointConfig) {
        super(triggerPointConfig);
    }

    @Override
    protected int getChannelsPerModule() {
        return 3;
    }

    public String toString() {
        return "ThreeChannelLedLevel " + super.toString();
    }

    @Override
    public void executeTransition(String callerString) {
        AppLog.info(callerString + " has triggered an LED level: " + this._triggerPointConfig.Name);
        Thread thd = new Thread(this);
        thd.setName(this._triggerPointConfig.Name + ":TypeF9");
        thd.setDaemon(true);
        thd.start();
    }

    @Override
    public void run() {
        int retries = 3;
        while (retries-- > 0) {
            try {
                this.setDimmers();
                break;
            }
            catch (Exception ex) {
                AppLog.error(Thread.currentThread().getName() + " had error executing Three Channel Dimmer", ex);
                AppLog.warn(Thread.currentThread().getName() + " retry");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDimmers() throws Exception {
        System.out.println(Thread.currentThread().getName() + " set dimmers - start");
        SensorPort sensorPort = port;
        synchronized (sensorPort) {
            try {
                long[] addr = AnalogPresetsMain._f9Addresses;
                short slewDuration = (short)this._triggerPointConfig.getTransitionTime();
                short slewDurationSwapEndian = ArrayUtils.swapEndian((short)slewDuration);
                long channelMask = this.getChannelMask();
                double[] percentages = this.getPercentagesForChannels();
                byte[] raw = new byte[17];
                raw[0] = 90;
                System.out.println(Thread.currentThread().getName() + " start loop");
                for (int moduleIndex = 0; 0L != channelMask && moduleIndex < addr.length; ++moduleIndex, channelMask >>= 3) {
                    long address = addr[moduleIndex];
                    if (0L == address || SensorPort.getDeviceType((long)address) != 249) continue;
                    ArrayUtils.setShort((byte[])raw, (int)1, (short)((channelMask & 1L) != 0L ? ArrayUtils.swapEndian((short)((short)(percentages[moduleIndex * 3] * 65534.0 / 100.0 + 1.0))) : (short)0));
                    ArrayUtils.setShort((byte[])raw, (int)3, (short)((channelMask & 2L) != 0L ? ArrayUtils.swapEndian((short)((short)(percentages[moduleIndex * 3 + 1] * 65534.0 / 100.0 + 1.0))) : (short)0));
                    ArrayUtils.setShort((byte[])raw, (int)5, (short)((channelMask & 4L) != 0L ? ArrayUtils.swapEndian((short)((short)(percentages[moduleIndex * 3 + 2] * 65534.0 / 100.0 + 1.0))) : (short)0));
                    ArrayUtils.setShort((byte[])raw, (int)11, (short)((channelMask & 1L) != 0L ? slewDurationSwapEndian : (short)0));
                    ArrayUtils.setShort((byte[])raw, (int)13, (short)((channelMask & 2L) != 0L ? slewDurationSwapEndian : (short)0));
                    ArrayUtils.setShort((byte[])raw, (int)15, (short)((channelMask & 4L) != 0L ? slewDurationSwapEndian : (short)0));
                    System.out.println(Thread.currentThread().getName() + " send data");
                    port.open();
                    port.select(address);
                    port.data(raw, 0, raw.length);
                    port.close();
                }
                System.out.println(Thread.currentThread().getName() + " trigger update");
                raw[0] = -31;
                raw[1] = -52;
                raw[2] = -106;
                port.open();
                port.reset();
                port.data(raw, 0, 3);
                port.close();
            }
            catch (Exception ex) {
                port.close();
                throw ex;
            }
        }
        System.out.println(Thread.currentThread().getName() + " set dimmers - finish");
    }

    private long getChannelMask() {
        long channelMask = 0L;
        for (int i = 0; i < this._triggerPointConfig.ThreeChannelDimmerChannels.length; ++i) {
            int channel = this._triggerPointConfig.ThreeChannelDimmerChannels[i];
            channelMask |= (long)(1 << channel - 1);
        }
        return channelMask;
    }

    private double[] getPercentagesForChannels() {
        double[] percentages = new double[64];
        int settingLevelCount = this._triggerPointConfig.Settings.length;
        for (int i = 0; i < this._triggerPointConfig.ThreeChannelDimmerChannels.length; ++i) {
            double percentage;
            int channel = this._triggerPointConfig.ThreeChannelDimmerChannels[i] - 1;
            int index = i % settingLevelCount;
            percentages[channel] = percentage = this._triggerPointConfig.Settings[index];
        }
        return percentages;
    }
}

