/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.analogpresets.websockethandlers;

import com.integpg.analogpresets.AnalogPresetsMain;
import com.integpg.analogpresets.AssemblyInfo;
import com.integpg.analogpresets.configuration.Config;
import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.messaging.websocket.WebsocketClientInformation;
import com.integpg.janoslib.messaging.websocket.WebsocketMessageEventObject;
import com.integpg.janoslib.messaging.websocket.WebsocketMessageHandler;
import com.integpg.janoslib.messaging.websocket.WebsocketServer;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.util.Json;

public class GetConfigHandler
extends WebsocketMessageHandler {
    public GetConfigHandler(Object parent) {
        super(parent);
    }

    @Override
    public String getMessage() {
        return "get-config";
    }

    @Override
    public void handleMessage(WebsocketMessageEventObject eventObject) throws Exception {
        AnalogPresetsMain parent = (AnalogPresetsMain)this._parent;
        WebsocketServer websocketServer = eventObject.getWebsocketServer();
        WebsocketClientInformation clientInformation = eventObject.getClientInformation();
        Json json = eventObject.getJson();
        int msgId = eventObject.getMsgId();
        try {
            Json responseJson = new Json();
            responseJson.put("Message", (Object)"config-resp");
            responseJson.put("Config", (Object)Config.getJson());
            Json devicesJson = new Json();
            devicesJson.put("FourTwentyPresent", (Object)new Boolean(this.devicesExist(AnalogPresetsMain._feDevices)));
            devicesJson.put("TenVoltPresent", (Object)new Boolean(this.devicesExist(AnalogPresetsMain._fdDevices)));
            devicesJson.put("ThreeChannelLEDPresent", (Object)new Boolean(this.devicesExist(AnalogPresetsMain._f9Devices)));
            responseJson.put("Devices", (Object)devicesJson);
            responseJson.put("Version", (Object)AssemblyInfo.getVersion());
            System.out.println("Send " + responseJson);
            websocketServer.sendToWebsocket(clientInformation, responseJson, msgId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("Error getting configuration");
        }
    }

    private boolean devicesExist(ExternalModule[] deviceArray) throws IOException {
        boolean exists = false;
        long[] connectedDevices = JANOS.getExternalDeviceList();
        if (deviceArray.length > 0 && connectedDevices.length > 0) {
            for (int i = 0; i < deviceArray.length; ++i) {
                ExternalModule module = deviceArray[i];
                if (null == module) continue;
                for (int j = 0; j < connectedDevices.length; ++j) {
                    if (module.Address != connectedDevices[j]) continue;
                    return true;
                }
            }
        }
        return exists;
    }
}

