/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.utils;

import com.integpg.janoslib.logger.AppLog;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.system.JANOS;

public class RegistryUtils {
    private static final String EMPTY_STRING = "";

    public static void moveFolder(String sourceFolder, String destFolder) {
        String[] keysToConvert;
        if (sourceFolder.endsWith("/")) {
            sourceFolder = StringUtils.trimEnd(sourceFolder, '/');
        }
        if (destFolder.endsWith("/")) {
            destFolder = StringUtils.trimEnd(destFolder, '/');
        }
        for (String key : keysToConvert = JANOS.getRegistryList((String)sourceFolder)) {
            String oldKey = String.format("%s/%s", sourceFolder, key);
            System.out.println("oldKey = " + oldKey);
            if (!key.startsWith("$")) {
                String value = JANOS.getRegistryString((String)oldKey, (String)EMPTY_STRING);
                AppLog.info(oldKey + " = " + value);
                String newKey = String.format("%s/%s", destFolder, key);
                JANOS.setRegistryString((String)newKey, (String)value);
            }
            AppLog.info("remove " + oldKey);
            JANOS.setRegistryString((String)oldKey, (String)EMPTY_STRING);
        }
    }

    public static String getRegistryKey(String keyName, String defaultValue) {
        String value = JANOS.getRegistryString((String)keyName, (String)EMPTY_STRING);
        if (value.equals(EMPTY_STRING)) {
            value = defaultValue;
            JANOS.setRegistryString((String)keyName, (String)value);
        }
        return value;
    }

    public static String[] getRegistryKeys(String keyName, String defaultValue) {
        String[] value = null;
        try {
            value = JANOS.getRegistryKey((String)keyName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (value == null || value.length == 0) {
            if (defaultValue != null && !defaultValue.equals(EMPTY_STRING)) {
                JANOS.setRegistryString((String)keyName, (String)defaultValue);
            }
            try {
                value = JANOS.getRegistryKey((String)keyName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return value;
    }

    public static boolean getRegistryKey(String keyName, boolean defaultValue) {
        boolean value = JANOS.getRegistryBoolean((String)keyName, (boolean)defaultValue);
        if (value == defaultValue) {
            JANOS.setRegistryString((String)keyName, (String)String.valueOf(value));
        }
        return value;
    }

    public static double getRegistryKey(String keyName, double defaultValue) {
        double value = JANOS.getRegistryDouble((String)keyName, (double)Double.MIN_VALUE);
        if (value == Double.MIN_VALUE) {
            value = defaultValue;
            JANOS.setRegistryString((String)keyName, (String)Double.toString(value));
        }
        return value;
    }

    public static int getRegistryKey(String keyName, int defaultValue) {
        int value = JANOS.getRegistryInt((String)keyName, (int)Integer.MIN_VALUE);
        if (value == Integer.MIN_VALUE) {
            value = defaultValue;
            JANOS.setRegistryString((String)keyName, (String)Integer.toString(value));
        }
        return value;
    }
}

