/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.logger;

import com.integpg.janoslib.logger.AppLog;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.FileLogService;
import java.io.PrintStream;

public abstract class Logger {
    protected long _nextFlushTime = Long.MAX_VALUE;
    protected PrintStream _printStream;
    protected boolean _finalized = false;

    public static Logger getLogger(String filename) {
        return FileLog.getHalfBackupLog(filename);
    }

    public long getNextFlushTime() {
        return this._nextFlushTime;
    }

    protected void setPrintStream(PrintStream printStream) {
        this._printStream = printStream;
    }

    public PrintStream getPrintStream() {
        return this._printStream;
    }

    public void vital(String vitalString) {
        this.println(String.format("## %s", vitalString));
    }

    public void info(String infoString) {
        this.println(infoString);
    }

    public void debug(String debugString) {
        this.println(String.format("?? %s", debugString));
    }

    public void warn(String warningString) {
        this.println(String.format(" * %s", warningString));
    }

    public void error(String errorString, Throwable ex) {
        this.error(errorString, ex, false);
    }

    public void error(String errorString, Throwable ex, boolean fromApplog) {
        if (null != ex) {
            String exceptionMessage = ex.getMessage();
            if (null == exceptionMessage) {
                exceptionMessage = ex.getClass().getName();
            }
            this.println(String.format("** %s: %s", errorString, exceptionMessage));
            if (!fromApplog) {
                AppLog.error(errorString, ex);
            }
        } else {
            this.error(errorString);
        }
    }

    public void error(String errorString) {
        this.println(String.format("** %s", errorString));
    }

    public void error(Throwable ex) {
        this.error(ex, false);
    }

    public void error(Throwable ex, boolean fromApplog) {
        this.println(String.format("** %s", ex.getMessage()));
        if (!fromApplog) {
            AppLog.error(ex);
        }
    }

    public void fatal(String fatalString) {
        this.println(String.format("*** %s", fatalString));
    }

    public void printf(String format, Object ... args) {
        this.println(String.format(format, args));
    }

    protected void println(String s) {
        this._printStream.println(s);
    }

    protected void print(String s) {
        this._printStream.print(s);
    }

    protected abstract void flush();

    static {
        FileLogService.start();
    }
}

