function getUri(defaultIpAddress) {
    // if the location is not set then prompt the user for the ip address
    var host;
    if (window.location.host == "")
        host = prompt("Enter an IP Address to connect to", defaultIpAddress);

    // build uri ------------------------------------------------------------------------------
    //  should use secure transport?
    var wsUri = "ws://";
    if (window.location.protocol == "https:")
        wsUri = "wss://";

    //  set host
    if (window.location.host != "")
        wsUri += window.location.host;
    else
        wsUri += host;

    console.log(wsUri);

    return wsUri;
}



// function initializePage() {
//     var connectionInfoOverlay = document.createElement('div');
//     connectionInfoOverlay.innerHTML = '<div id="connection-lost" class="message-overlay"><div id="connection-state" class="overlay-text"></div></div>';
//     document.body.appendChild(connectionInfoOverlay);


//     var loginDialog = document.createElement('div');
//     loginDialog.innerHTML = '<div class="sweet-overlay"></div><div class="sweet-alert"><div class="icon error"><span class="x-mark"><span class="line left"></span><span class="line right"></span></span></div><div class="icon warning"> <span class="body"></span> <span class="dot"></span> </div> <div class="icon info"></div> <div class="icon success"> <span class="line tip"></span> <span class="line long"></span> <div class="placeholder"></div> <div class="fix"></div> </div> <div class="icon custom"></div> <h2>Title</h2><p>Text</p><button class="cancel">Cancel</button><button class="confirm">OK</button></div>';
// //    document.body.appendChild(loginDialog);
// }



// (function() {
//     if (document.readyState === "complete" || document.readyState === "interactive") {
//         initializePage();
//     } else {
//         if (document.addEventListener) {
//             document.addEventListener('DOMContentLoaded', function factorial() {
//                 document.removeEventListener('DOMContentLoaded', arguments.callee, false);
//                 initializePage();
//             }, false);
//         } else if (document.attachEvent) {
//             document.attachEvent('onreadystatechange', function() {
//                 if (document.readyState === 'complete') {
//                     document.detachEvent('onreadystatechange', arguments.callee);
//                     initializePage();
//                 }
//             });
//         }
//     }
// })();



function JnrWebSocket(obj) {
    var instance = this;
    var websocket;
    var pingTime;
    var pingResponseTimer;
    var pingRetries = 3;
    var pingInProgress = false;

    this.obj = obj;
    this.monitor = {};

    var jws = this;


    this.connect = function() {
        $('#connection-state').html("Web Socket Connecting...");
        $('#connection-state').css('color', '#c0392b');


        var uri = getUri(this.obj.defaultIpAddress);
        if (this.obj.appId != null)
            uri += "?app=" + this.obj.appId;


        websocket = new WebSocket(uri);


        websocket.onopen = function(evt) {
            instance.sendPing();


            console.log("Web Socket Connected!");
            $('#connection-state').html("Web Socket Connected!  Waiting for application...");
            $('#connection-state').css('color', '#f1c40f');


            if (jws.obj.appId == undefined) {
                setTimeout(function() {
                    $('#connection-lost').fadeOut(500);
                }, 500);
            }


            if (instance.obj.onopen != null)
                instance.obj.onopen(evt);
        };


        websocket.onmessage = function(evt) {
            $('#connection-state').html("Web Socket Connected!  Application Connected!");
            $('#connection-state').css('color', '#27ae60');


            // clear the ping response timer
            pingInProgress = false;
            clearTimeout(pingResponseTimer);
            $('#connection-lost').fadeOut(250);


            // get a json object from our message
            var jobj = jQuery.parseJSON(evt.data);

            // get the type of message that was received
            var message = jobj['Message'];


            if (message === 'ping-resp') {
                console.log('ping response received');

                instance.pingResponse(jobj);
            } else {
                // send another ping in 30 seconds
                console.log("send another ping in 30 seconds");
                pingResponseTimer = setTimeout(function() {
                    instance.sendPing()
                }, 30000);


                console.log(new Date().getTime() + "   RECV -->:   " + evt.data);

                if (message === 'Error' && jobj['Text'] == '401 Unauthorized') {
                    if (instance.obj.getAuthentication != null)
                        instance.obj.getAuthentication(evt, jobj);
                    else
                        $('#dialog-login').dialog('open');

                } else if (message === 'Authenticated') {
                    if (instance.obj.authenticated != null)
                        instance.obj.authenticated(evt, jobj);
                } else if (message === 'Monitor') {
                    instance.monitor = jobj;
                }


                var func = instance.messageHandlers[jobj.Message];
                if (func != null) {
                    func(evt, jobj);
                } else {
                    if (instance.obj.onmessage != null)
                        instance.obj.onmessage(evt, jobj);
                }
            }
        };


        websocket.onclose = function(evt) {
            setTimeout(function() {
                instance.connect();
            }, 5000);


            $('#connection-state').html("Web Socket Connection Lost!");
            $('#connection-state').css('color', '#c0392b');
            $('#connection-lost').fadeIn(500);


            console.log("Web Socket Disconnected!");
            if (instance.obj.onclose != null)
                instance.obj.onclose(evt);
        };


        websocket.onerror = function(evt) {
            console.log("Error " + evt.data + "!");
            if (instance.websocket != null)
                instance.websocket.close();

            if (instance.obj.onerror != null)
                instance.obj.onerror(evt);
        };
    }



    this.messageHandlers = new Array();



    this.command = function(command, channel) {
        // build the json message to send
        var json = {'Message': 'Control', 'Command': command, 'Channel': channel};
        this.sendJson(json);
    };



    this.sendJson = function(json) {
        var message = JSON.stringify(json);

        // Wait while the state of the socket is not ready and send the message when it is...
        waitForSocketConnection(websocket, function() {
            if (message != '')
                console.log(new Date().getTime() + "   SEND -->:   " + message);
            websocket.send(message);
        });
    }



    // Make the function wait until the connection is made...
    var waitForSocketConnection = function(socket, callback) {
        if (socket.readyState === 1) {
//            console.log("Connection is made")
            if (callback != null)
                callback();
            return;

        } else if (socket.readyState === 0) {
            console.log("wait for connection...")
            setTimeout(function() {
                waitForSocketConnection(socket, callback);
            }, 1000); // wait 1000 miliseconds for the connection...
        } else {
            console.log("Web Socket Aborted!")
        }
    }



    this.sendPing = function() {
        if (pingInProgress)
            return;
        pingInProgress = true;


        this.sendJson({'Message': 'ping'});


        pingTime = new Date().getTime();
        $('#ping').html('ping sent');
        pingRetries--;


        pingResponseTimer = setTimeout(function() {
            console.log('ping retries remaining: ' + pingRetries);


            if (pingRetries <= 0) {
                $('#connection-state').html("Web Socket Connected!  Application Not Responding!");
                $('#connection-state').css('color', '#f1c40f');
                $('#connection-lost').fadeIn(500);
            }


            pingInProgress = false;
            $('#ping').html('PING FAILED');


            // send another ping in 2.5 seconds
            pingResponseTimer = setTimeout(function() {
                instance.sendPing()
            }, 2500);
        }, 2500);
    }



    this.pingResponse = function(jobj) {
        pingInProgress = false;
        pingRetries = 3;


        $('#log').append('<p>Ping Repsonse Received:  (' + (new Date().getTime() - pingTime) + ')</p>');

        // send another ping in 15 seconds
        setTimeout(function() {
            instance.sendPing()
        }, 15000);
    }
}