/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.modbusserver;

import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.system.RegistryHelper;
import com.integpg.sensor.SensorPort;
import com.integpg.system.JANOS;
import java.io.IOException;

public class ExternalModuleConfig {
    public static void init() {
        try {
            long[] addresses;
            for (long address : addresses = SensorPort.externalDeviceList()) {
                String addressString = "0000000000000000" + Long.toHexString(address);
                addressString = addressString.substring(addressString.length() - 16);
                ExternalModuleConfig.getModbusAddressForModule(addressString);
            }
        }
        catch (IOException ex) {
            AppLog.error("Error enumerating externaldevices", ex);
        }
    }

    public static int getModbusAddressForModule(String addressString) {
        String modbusAddressRegistryKeyString = "OneWire/" + addressString + "/ModbusAddress";
        int storeAddress = JANOS.getRegistryInt((String)modbusAddressRegistryKeyString, (int)-1);
        JANOS.setRegistryString((String)modbusAddressRegistryKeyString, (String)"");
        modbusAddressRegistryKeyString = "Externals/" + addressString + "/ModbusAddress";
        return RegistryHelper.getRegistryKey(modbusAddressRegistryKeyString, storeAddress);
    }
}

